
// Hollywood API for use with the Macintosh Sound Manager 3.0
//
// History
//	1/8/95	Created by Steve Hales

#ifndef _MAC_SOUND_
#define _MAC_SOUND_

#define	kUseAnyVoice		-1				// Pass into any function that requires a voice channel,
										// and this will auto determine the voice to use.

// Sound callback What events process through custom callback procedures
#define	kSoundDoneNormalStop		1		// at interrupt time, just before final sample
#define	kSoundDoneForcedStop		2		// at interrupt time and non interrupt time, used when sound is stopped
										// before playing out
#define	kSoundDoneNoInterrupt		3		// at non interrupt time, sometimes after final sample


// Feature mask for HY_Setup
#define	kNormal					0x0		// mono 8 bit
#define	kUseStereo				0x1		// if present then stereo audio is setup
#define	kMaxQuality				0x2		// if present then interpolation is enabled, and drop sampling disabled

// mask for stereo positioning
#define	kFullLeft					(-0x100)
#define	kMiddle					0x0
#define	kFullRight					0x100

#define MakeVolume(left, right)	((long)(((right) << 16L) | (long)(left)))

// Types
typedef void (*CustomCallbackProc)(short int voiceNumber, short int what, long userData);
typedef Handle SndReference;

struct SoundVolume
{
	short int	right;		// high 16 bits
	short int	left;			// low 16 bits
};
typedef struct SoundVolume SoundVolume;


// Audio Sample Data Format. (ASDF)
// Support for 8, 16 bit data, mono and stereo. Can be extended for multi channel beyond 2 channels, but
// not required at the moment.
//
//	DATA BLOCK
//		8 bit mono data
//			ZZZZZZZ
//				Z = signed 8 bit data
//
//		16 bit mono data
//			WWWWW
//				W = signed 16 bit data
//
//		8 bit stereo data
//			ZXZXZXZX
//				Z = signed 8 bit data for left channel, X = signed 8 bit data for right channel.
//
//		16 bit stereo data
//			WQWQWQ
//				W = signed 16 bit data for left channel, Q = signed 16 bit data for right channel.
//



Boolean			HY_Is16BitAvailable(void);
Boolean			HY_IsStereoAvailable(void);

OSErr			HY_Setup(short int featureMask, short int maxVoices);

OSErr			HY_Cleanup(void);

Boolean			HY_Active(void);

void				HY_RegisterThisSound(SndReference theSound);
SndReference		HY_GetSoundResource(short int resourceID);
void				HY_UnregisterSoundResource(SndReference theSound);
void				HY_UnregisterAllSoundResources(void);

OSErr			HY_PlaySoundHandle(	short int voiceNumber, 
									SndReference theSound,
									CustomCallbackProc callbackProc,	
									long userData, 
									Boolean killSound);

OSErr			HY_PlaySample(	short int voiceNumber,
								void *pSample,
								long length,
								UnsignedFixed rate,
								short dataBitSize,
								short channelSize,
								CustomCallbackProc callbackProc,
								long userData,
								Boolean killSound);

Boolean			HY_IsVoiceEmpty(short int voiceNumber);

void				HY_StopSample(short int voiceNumber);

void				HY_SetRate(short int voiceNumber, UnsignedFixed newRate);
UnsignedFixed		HY_GetRate(short int voiceNumber);

void				HY_SetVolume(short int voiceNumber, SoundVolume newVolume);
SoundVolume		HY_GetVolume(short int voiceNumber);
void				HY_SetStereoPosition(short int voiceNumber, short positionMask);
short			HY_GetStereoPosition(short int voiceNumber);

void				HY_ServiceTasks(void);

OSErr			HY_PauseHardware(void);
OSErr			HY_ResumeHardware(void);

void				HY_SetSoundVBCallBack(void (*theProc)(void));

OSErr			HY_StartFilePlay(	short int voiceNumber, 
								FSSpec *pFile, 
								CustomCallbackProc customCallback,	
								long userData,
								long bufferSize,
								Boolean killSound);

Handle			HY_GetMACESound(	CmpSoundHeaderPtr pSndBuffer, 
								Ptr *pWave, 
								long *length, 
								long *loopstart, 
								long *loopend, 
								long *rate);

OSErr			HY_GetSoundResourceInformation(	Handle theSnd, long *pLoopStart, long *pLoopEnd, 
											long *pSampleOffsetStart, long *pTotalSize, short *pBaseKey,
											short int *pNumChannels, short int *pBitSize,
											UnsignedFixed *pRate,
											short int *pCompressionType);

Handle			HY_CreateSndResourceFromPtr(Ptr pSample, long dataLength, UnsignedFixed sampleRate, 
										short bitSize, short numChannels,
										short int baseFreq);

OSErr			HY_CreateAIFFFileFromPtr(FSSpec *pFile, Ptr pSample, long dataLength, UnsignedFixed sampleRate, 
										short bitSize, short numChannels);

Handle			HY_CreateMACESndResourceFromPtr(short maceType, Ptr pSample, long dataLength, 
										UnsignedFixed sampleRate, 
										short bitSize, short numChannels,
										short int baseFreq);


#endif _MAC_SOUND_
